/************************************************************************
 *
 * \file: mspin_demo_iap2_gadget_loader.h
 *
 * \version: $Id:$
 *
 * \release: $Name:$
 *
 * <brief description>.
 * <detailed description>
 * \component: mySPIN - Demo application
 *
 * \author: Bui Le Thuan / thuan.buile@vn.bosch.com
 *
 * \copyright (c) 2015 Advanced Driver Information Technology.
 * This code is developed by Advanced Driver Information Technology.
 * Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
 * All rights reserved.
 *
 * \see <related items>
 *
 * \history
 *
 ***********************************************************************/

#ifndef MSPIN_DEMO_IAP2_GADGETLOADER_H
#define MSPIN_DEMO_IAP2_GADGETLOADER_H

#include <string>
#include <iap2_init.h>
#include <iap2_usb_role_switch.h>
#include <iap2_initialize_usb_gadget.h>


/* **********************  defines   ********************** */

/* Kernel 3.14 necessary kernel modules to load libcomposite and g_ffs */
#define CONFIGFS_MODULE_NAME                    "configfs"
#define USB_F_FS_MODULE_NAME                    "usb_f_fs"
#define U_ETHER_MODULE_NAME                     "u_ether"
#define USB_F_NCM_MODULE_NAME                   "usb_f_ncm"
#define USB_F_UAC2_NAME                         "usb_f_uac2"


#define LIBCOMPOSITE_MODULE_NAME                "libcomposite"
#define GADGET_FFS_MODULE_NAME                  "g_ffs"
#define LINUX_USB_GADGET_MODULE_PATH            "/lib/modules/%s/kernel/drivers/usb/gadget/%s.ko"

#define FUNCTION_FS_NAME                        "ffs"
#define CONFIG_FS_NAME                          "config"
#define FUNCTION_FS_PATH                        "/dev/ffs"
#define CONFIG_FS_PATH                          "/sys/kernel/config"
#define FUNCTION_FS_TYPE                        "functionfs"
#define CONFIG_FS_TYPE                          "configfs"

#define STR_USB_DYN_NUM                         "usb*"

#define STR_GADGET                              "gadget"
#define STR_HOST                                "host"

/* vbus is not available in case we are not for example on a imx6-qai target */
#define STR_VBUS_AUTO                           "vbus_auto"
#define STR_ENABLE                              "enable"
#define STR_DISABLE                             "disable"

/* Depreciated */
#define IAP2_ACC_CONFG_TRANS_USB_OTG_GPIO_POWER_AI          "425"
#define IAP2_ACC_CONFG_TRANS_USB_OTG_GPIO_POWER_SD          "86"

/* g_ffs load module parameter */
#define STR_ACC_INFO_NAME                       "AmazingProduct"
#define STR_ACC_INFO_MANUFACTURER               "ADIT"
#define STR_ACC_INFO_SERIAL_NUM                 "12345678"
#define STR_ACC_INFO_VENDOR_ID                  "44311"
#define STR_ACC_INFO_PRODUCT_ID                 "1111"
#define STR_ACC_INFO_BCD_DEVICE                 "1"
#define STR_ACC_INFO_QMULT                      "1"

#define STR_MAX_LENGTH                          256
#define MAX_STRING_LEN                          256


typedef struct {
    char vendorId[MAX_STRING_LEN];
    char productId[MAX_STRING_LEN];
    char manufacturer[MAX_STRING_LEN];
    char name[MAX_STRING_LEN];
    char serial[MAX_STRING_LEN];
    char bcdDevice[MAX_STRING_LEN];
    char qmult[MAX_STRING_LEN];
} iap2LoadGadgetFSModuleParameters_t;

typedef union
{
    iap2LoadGadgetFSModuleParameters_t gadget_fs;
} iap2LoadModuleParameters;


class GadgetLoader
{
private:
    uint32_t iap2CurrTimeMs(void);
    uint32_t iap2CurrTimeValToMs(struct timeval* currTime);

public:
    GadgetLoader ();
    ~GadgetLoader();

   int32_t LoadKernelModule(const iap2LoadModuleParameters* iap2ModuleLoadParam, const char* modname, uint32_t length);
   int32_t UnloadKernelModule(const char* modname);
};

#endif /* MSPIN_DEMO_IAP2_GADGETLOADER_H */
